/* global sc */

let $$ = require('../utils/debug')({ debug: true, path: module.id, prefix: '[cdev.ncore - init node_modules]' });
$$.objects = require('common/objects');

// (re-) create customers/node_modules to publish agorum Libraries
let target = $$.objects.tryFind('/agorum/roi/customers/node_modules');
target && target.delete();
target = $$.objects.find('/agorum/roi/customers').createPath('node_modules');
$$.debug('target', target);

let libraries = $$.objects.tryFind('/agorum/roi/Scripting/Libraries');
$$.debug('libraries', libraries);

// copy(!) all agorum Libraries to customers/node_modules
if (libraries && target) {
  libraries.items().forEach(item => {
    $$.objects.copy(item, target);
  });
}

'Done: ' + new Date();
